SELECT 
    L_SHIPMODE, 
    SUM(LINE_COUNT(O_ORDERPRIORITY, 'high')) AS HIGH_LINE_COUNT, 
    SUM(LINE_COUNT(O_ORDERPRIORITY, 'low')) AS LOW_LINE_COUNT
FROM 
    ORDERS, 
    LINEITEM
WHERE 
    O_ORDERKEY = L_ORDERKEY 
    AND Q12CONDITIONS(L_SHIPMODE, L_COMMITDATE, L_RECEIPTDATE, L_SHIPDATE) = 1
GROUP BY 
    L_SHIPMODE
ORDER BY 
    L_SHIPMODE NULLS FIRST;